<?php

class ControladorPersonas{
	

	/*=============================================
	CREAR CLIENTES
	=============================================*/

	static public function ctrCrearPersona(){

		if(isset($_POST["nuevoNombres"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombres"]) &&			   
			   preg_match('/^[()\-0-9 ]+$/', $_POST["nuevoTelefono"]) && preg_match('/^[a-zA-Z0-9 ]+$/', $_POST["nuevoDocumento"])){

			   	$tabla = "persona";


			   	$datos = array(
					   			"nombres"=>$_POST["nuevoNombres"],
								"codigo"=>$_POST["codigo"],
					           "documento"=>$_POST["nuevoDocumento"],
					           "sexo"=>$_POST["sexo"],
					           "universidad"=>$_POST["universidad"],
					           "fecha_nacimiento"=>$_POST["nuevoFechaNacimiento"],
					           "telefono"=>$_POST["nuevoTelefono"],
					           "idzona"=>$_POST["nuevoZona"],
					           "nuevaDireccion"=>$_POST['nuevaDireccion'],
					           "email"=>$_POST["nuevoEmail"]);


			   	$respuesta = ModeloPersonas::mdlIngresarPersona($tabla, $datos);
			
			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El cliente ha sido guardado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "personas";

									}
								})

					</script>';

				} 

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El Cliente no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "personas";

							}
						})

			  	</script>';



			}

		}

	}

	/*=============================================
	MOSTRAR CLIENTES
	=============================================*/

	static public function ctrMostrarPersonas($item, $valor, $all = false){

		$tabla = "persona_direcciones";

		$respuesta = ModeloPersonas::mdlMostrarPersonas($tabla, $item, $valor, $all);

		return $respuesta;
		//SELECT * FROM persona as p INNER JOIN direcciones as d ON p.id_direccion=d.iddireccion INNER JOIN zona as z ON d.id_zona=z.idzona  WHERE idpersona = 2

	}


	static public function ctrMostrarPersonaServicio($item, $valor){

		$tabla = "persona_servicio";

		$respuesta = ModeloPersonas::mdlMostrarPersonaServicio($tabla, $item, $valor);

		return $respuesta;

	}

	static public function ctrMostrarPersona($item, $valor){

		$tabla = "persona";

		$respuesta = ModeloPersonas::mdlMostrarPersona($tabla, $item, $valor);

		return $respuesta;

	}
	

	/*=============================================
	EDITAR CLIENTE
	=============================================*/

	static public function ctrEditarPersona(){

		if(isset($_POST["editarNombres"])){
			
			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["editarNombres"]) &&			   
			   preg_match('/^[()\-0-9 ]+$/', $_POST["editarTelefono"]) && preg_match('/^[a-zA-Z0-9 ]+$/', $_POST["editarDocumento"])){

			   	$tabla = "persona";

			   	$datos = array(
					   			"idpersona" => $_POST['idpersona'],
								"codigo"=>$_POST["editarCodigo"],
			   				   "nombres"=>$_POST["editarNombres"],
					           "documento"=>$_POST["editarDocumento"],
					           "sexo"=>$_POST["editarSexo"],
					           "fecha_nacimiento"=>$_POST["editarFechaNacimiento"],
					           "telefono"=>$_POST["editarTelefono"],
					           "idzona"=>$_POST["editarZona"],
					           "direccion"=>$_POST["editarDireccion"],
					           "email"=>$_POST["editarEmail"]);

			   	$respuesta = ModeloPersonas::mdlEditarPersona($tabla, $datos);

			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El Cliente ha sido actualizado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "personas";

									}
								})

					</script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El cliente no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "personas";

							}
						})

			  	</script>';



			}

		}

	}

	/*=============================================
	ELIMINAR CLIENTE
	=============================================*/

	static public function ctrEliminarPersona(){

		if(isset($_GET["idPersona"])){

			$tabla ="persona";
			$datos = $_GET["idPersona"];

			$respuesta = ModeloPersonas::mdlEliminarPersona($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El cliente ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result){
								if (result.value) {

								window.location = "personas";

								}
							})

				</script>';

			}		

		}

	}

}

